#!/bin/bash

for bmp in ../../*.bmp; do
    base=`basename $bmp .bmp`
    png="$base.png"
    if [ -f $bmp ]; then
        if [ $bmp -nt $png ]; then
            echo "creating $png"
            convert -crop 640x416+0+0 -scale 120x78 $bmp $png
#           mogrify -crop 640x416+0+0 $png
#           mogrify -scale 20% $png
        fi
    fi
done

if test -d ../../Sokoban; then
    for bmp in ../../Sokoban/*.bmp; do
        base=`basename $bmp .bmp`
        png="Sokoban/$base.png"
        if [ -f $bmp ]; then
            if [ $bmp -nt $png ]; then
                echo "creating $png"
                convert -crop 640x416+0+0 -scale 120x78 $bmp $png
            fi
        fi
    done
fi

# if pngcrush is installed crush previews
if [ -x /usr/local/bin/pngcrush ] ; then
    NEWPREVIEWS=`find . -name "*.png" -cmin -2`
    ./04crushprevievs.sh $NEWPREVIEWS
fi
